% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{[.rasterly}
\alias{[.rasterly}
\title{Extract or replace parts of a `rasterly` object}
\usage{
\method{[}{rasterly}(x, name)
}
\arguments{
\item{x}{Object from which to extract element(s) or in which to replace element(s).}

\item{name}{Character. A literal string to be extracted from `x`. See details for more information.}
}
\description{
The `extract` function provides functionality for updating existing `rasterly` objects.
}
\details{
Available names:
\itemize{
 \item{Aggregation: }{"data", "mapping", "plot_width", "plot_height", "range", "x_range",
"y_range", "xlim", "ylim", "aesthetics", "reduction_func", "glyph",
"max_size", "group_by_data_table", "drop_data", "variable_check"}
 \item{Display: }{"background", "color_map", "color_key", "alpha", "span",
 "show_raster", "layout"}
}
}
\examples{
library(rasterly)
r <- rasterly(
       data = data.frame(x = 1:1e4, y = runif(1e4), category = sample(1:4, 1e4, replace = TRUE)),
       mapping = aes(x = x, y = y)
) \%>\%
  rasterize_points(xlim = c(1, 5000)) \%>\%
  rasterize_points(
    mapping = aes(x = x, y = y, color = category),
    xlim = c(5001, 1e4)
  )
r["mapping"]
r["xlim"]

# reassign parent `rasterly()` mapping
r["mapping"] <- aes(x = x, y = y, color = category)
r["mapping"]

# reassign all mapping systems
r["mapping", level = 1:length(r)] <- aes(x = x, y = y)
r["mapping"]
}
