% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop.R
\name{crop,RasterList-method}
\alias{crop,RasterList-method}
\alias{crop}
\title{\code{Crop} methods for a \code{\link{RasterList-class}} object.}
\usage{
\S4method{crop}{RasterList}(x, y, check.RasterList = TRUE, ...)
}
\arguments{
\item{x}{a valid object}

\item{y}{a Spatial Object or an Extent}

\item{check.RasterList}{logical value. If it is \code{TRUE}, it checks the \code{x} \code{\link{RasterList-class}} object. Default is \code{FALSE}.}

\item{...}{further arguments}
}
\value{
a "cropped" \code{\link{RasterList-class}} object
}
\description{
\code{Crop} methods for a \code{\link{RasterList-class}} object.
}
\examples{


precf <- system.file("map/precipitation.grd", package="rasterList")
prec <- stack(precf)
\donttest{
## Sample L-moments 

library(lmom)

samlmom <- stack(rasterList(prec,FUN=samlmu))
## Fitting a Random Probability Distribution: it is a 'rasterList' Object
fitdist <- rasterList(samlmom,FUN=pelgam)

##### ZOOM IN 
## set a mask 
mask <-raster( extent(fitdist)/4 )


fitdist_masked <- crop ( x = fitdist,y=mask)
}




}
