% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raptr.R
\docType{package}
\name{raptr}
\alias{raptr}
\title{raptr: Representative and Adequate Prioritization Toolkit in R}
\description{
Biodiversity is in crisis. The overarching aim of conservation is to preserve
biodiversity patterns and processes. To this end, protected areas are
established to buffer species and preserve biodiversity processes. But
resources are limited and so protected areas must be cost-effective. This
package contains tools to generate plans for protected areas
(prioritizations). Conservation planning data are used to construct an
optimization problem, which is then solved to yield prioritizations. To
solve the optimization problems in a feasible amount of time, this package
uses the commercial 'Gurobi' software package (obtained from
\url{http://www.gurobi.com/}). For more information on using
this package, see Hanson et al. (2018)
(\url{https://doi.org/10.1111/2041-210X.12862}).
}
\details{
The main classes used in this package are used to store input data and
prioritizations:
\describe{
\item{\linkS4class{GurobiOpts}}{parameters for solving optimization
problems using Gurobi.}
\item{\linkS4class{RapReliableOpts}}{parameters for the reliable
formulation of RAP.}
\item{\linkS4class{RapUnreliableOpts}}{parameters for the unreliable
formulation of RAP.}
\item{\linkS4class{RapData}}{planning unit, species data, and demand
points for RAP.}
\item{\linkS4class{RapUnsolved}}{contains all the data and input
parameters required to generate prioritizations using RAP. This class
contains a \linkS4class{GurobiOpts} object, a
\linkS4class{RapReliableOpts} or \linkS4class{RapUnreliableOpts}
object, and a \linkS4class{RapData} object.}
\item{\linkS4class{RapResults}}{prioritizations and summary
statistics on their performance.}
\item{\linkS4class{RapSolved}}{contains all the input data,
parameters and output data. This class contains all the objects in a
\code{\link[=RapUnsolved]{RapUnsolved()}} object and also a \linkS4class{RapResults}
object.}
}

Type \code{vignette("raptr")} for a tutorial on how to use this package.
}
