% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AttributeSpaces.R
\name{AttributeSpaces}
\alias{AttributeSpaces}
\title{Create new AttributeSpaces object}
\usage{
AttributeSpaces(spaces, name)
}
\arguments{
\item{spaces}{\code{list} of \code{\link[=AttributeSpace]{AttributeSpace()}} objects for
different species.}

\item{name}{\code{character} name to identify the attribute space.}
}
\description{
This function creates a new \code{AttributeSpaces} object.
}
\examples{
space1 <- AttributeSpace(
  PlanningUnitPoints(
    matrix(rnorm(100), ncol = 2),
    seq_len(50)),
  DemandPoints(
    matrix(rnorm(100), ncol = 2),
    runif(50)),
  species = 1L)

space2 <- AttributeSpace(
  PlanningUnitPoints(
    matrix(rnorm(100), ncol = 2),
    seq_len(50)),
  DemandPoints(
    matrix(rnorm(100), ncol = 2),
    runif(50)),
  species = 2L)

spaces <- AttributeSpaces(list(space1, space2), "spaces")

}
\seealso{
\linkS4class{AttributeSpace}.
}
