% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{eoo}
\alias{eoo}
\title{Extent of occurrence of a species based on convex hull polygons}
\usage{
eoo(occurrences, polygons)
}
\arguments{
\item{occurrences}{a data.frame containing geographic coordinates of species
occurrences, columns must be: Species, Longitude, and Latitude. Geographic
coordinates must be in decimal degrees (WGS84).}

\item{polygons}{SpatialPolygons object to clip convex hulls to these limits.
Projection must be WGS84 (EPSG:4326).}
}
\value{
A list containing a SpatialPolygonsDataFrame of the extent of occurrence, and
a vector with the areas in km2 of the spatial polygons resulted. Projection
of resulting spatial object is Lambert Azimuthal Equal Area.
}
\description{
Extent of occurrence of a species based on convex hull polygons
}
\details{
Areas are calculated in square kilometers using the Lambert Azimuthal Equal
Area projection, centered on the centroid of occurrence points given as
inputs.
}
\examples{
# occurrences
data("occ_f", package = "rangemap")
occ <- unique(occ_f)

# polygons
poly <- simple_wmap("simple", "Cuba")
LAEA <- LAEA_projection(occ[, 2:3])
poly_pr <- sp::spTransform(poly, LAEA)

# to fix topology problems
poly_pr <- rgeos::gBuffer(poly_pr, width = 0)

# EOO
eoo_pe <- eoo(occurrences = occ, polygons = poly_pr)
}
