% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{hull_polygon}
\alias{hull_polygon}
\title{Convex or concave hull polygons from spatial points}
\usage{
hull_polygon(occ_pr, hull_type = "convex", concave_distance_lim = 5000,
             verbose = TRUE)
}
\arguments{
\item{occ_pr}{SpatialPoints* object containing geographic points to be used
to create hull polygons. This spatial object must be projected to a system
with the argument "+units=m".}

\item{hull_type}{(character) type of hull polygons to be created. Available
options are: "convex" and "concave". Default = "convex".}

\item{concave_distance_lim}{(numeric) distance, in meters, to be passed to the
length_threshold parameter of the \code{\link[concaveman]{concaveman}} function.
Default = 5000. Ignored if \code{hull_type} is not "concave".}

\item{verbose}{(logical) whether or not to print messages about the process.
Default = TRUE.}
}
\value{
A SpatialPolygons object with the hull polygon. If the number of points
in occ_pr is 1 or 2 a SpatialPointsDataFrame object is returned.
}
\description{
Convex or concave hull polygons from spatial points
}
\examples{
# data
data("occ_p", package = "rangemap")

# preparing spatial points
occ <- as.data.frame(unique(occ_p))
WGS84 <- sp::CRS("+init=epsg:4326")
occ_sp <- sp::SpatialPointsDataFrame(coords = occ[, 2:3], data = occ,
                                     proj4string = WGS84)

# reprojecting
LAEA <- LAEA_projection(spatial_object = occ_sp)
occ_pr <- sp::spTransform(occ_sp, LAEA)

# convex hull polygon
cvx_hull <- hull_polygon(occ_pr, hull_type = "convex")
}
