% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/country_codes.R
\docType{data}
\name{adm_area_names}
\alias{adm_area_names}
\title{List of names of administrative areas form the GADM data base}
\format{
A data frame with 41535 rows and 4 columns.
\describe{
\item{ISO3}{character, country code.}
\item{NAME_0}{character, name of administrative areas at level 0.}
\item{NAME_1}{character, name of administrative areas at level 1.}
\item{NAME_2}{character, name of administrative areas at level 2.}
}
}
\source{
\url{https://gadm.org/}
}
\usage{
adm_area_names
}
\description{
A dataset containing names of all the available administrative
areas from the GADM data base. Names describe distinct administrative areas
in five levels.
}
\examples{
data("adm_area_names", package = "rangemap")
adm_area_names[1:10, 1:4]

# Country names: Level 0
unique(adm_area_names$NAME_0)

# Provinces of a country: Level 1
as.character(unique(adm_area_names[adm_area_names$NAME_0 == "Ecuador", "NAME_1"]))

# Some administrative areas at level 2 of India
l2_India <- as.character(unique(adm_area_names[adm_area_names$NAME_0 == "India",
                                               "NAME_2"]))
}
\keyword{datasets}
