% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csvConversion.R
\name{rmmToCSV}
\alias{rmmToCSV}
\title{Create .csv File From rangeModelMetaData Object}
\usage{
rmmToCSV(x = rmmTemplate(family = NULL), filename = NULL)
}
\arguments{
\item{x}{An object of class \code{rmm} that the user wishes transposed into a .csv file.}

\item{filename}{The name of the transcription .csv file.}
}
\value{
An data frame containing all the information from an \code{rmm} object.
}
\description{
Takes user-input rangeModelMetaData object and from it generates a .csv file that can be used to document range model metadata for a variety of applications.
}
\details{
See Examples.
}
\examples{
rmm=rmmTemplate()
rasterFiles=list.files(path=paste(system.file(package='dismo'), '/ex', sep=''),
                       pattern='grd', full.names=TRUE)
#make a stack of the rasters
env=raster::stack(rasterFiles)
# for fitting environment
rmm=rmmAutofillEnvironment(rmm,env,transfer=0)
# for the first environment that you're transfering to
rmm=rmmAutofillEnvironment(rmm,env,transfer=1)
# for the second environment that you're transfering to, etc.
rmm=rmmAutofillEnvironment(rmm,env,transfer=2)
\dontrun{
tmp=rmmToCSV(rmm,file='somePathOnYourMachine/rmm_example.csv')
}
}
\seealso{
Other csvConversion: 
\code{\link{cleanForCSV}()},
\code{\link{csvToRMM}()}
}
\author{
Hannah Owens <hannah.owens@gmail.com>, Cory Merow <cory.merow@gmail.com>
}
\concept{csvConversion}
