% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projectINI-methods.R
\name{rangeMap}
\alias{rangeMap}
\alias{rangeMap.open}
\alias{rangeMap.start}
\title{Initiate/open a new rangeMapper project}
\usage{
rangeMap(path)

rangeMap.start(dir, file, overwrite = FALSE)

rangeMap.open(path, verbose = TRUE)
}
\arguments{
\item{path}{character vector; a path to a valid rangeMapper project.}

\item{dir}{project directory.}

\item{file}{project file name.}

\item{overwrite}{logical vector, default to FALSE (the file is kept but all tables are dropped).}

\item{verbose}{character vector; if \code{TRUE} the project's summary is printed.}
}
\value{
rangeMap.start() and rangeMap.open() returns an sqlite connection\cr
				rangeMap() returns an object of class  \code{rangeMap}
}
\description{
Initiate/open a new rangeMapper project
}
\examples{

td = setwd(tempdir())

dbcon = rangeMap.start(file = "test.sqlite", overwrite = TRUE, dir = tempdir() )
summary(dbcon)

summary(rangeMap("test.sqlite"))

dbcon = rangeMap.open(path = "test.sqlite")
summary(dbcon)
setwd(td)


}
\seealso{
\code{\link{rangeMap.save}}
}

