% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probUnDes.R
\name{probUnDes}
\alias{probUnDes}
\alias{probUnDes,desScores-method}
\title{Computing the probability of having desirability scores of zero}
\usage{
probUnDes(desScore)

\S4method{probUnDes}{desScores}(desScore)
}
\arguments{
\item{desScore}{an object of the class \code{desScores}, i.e. an object resulting from
applying the function \code{\link{getDesScores}}}
}
\value{
\code{S4} object of class \code{probUnDesirable} computing the probability of getting
undesirable scores, i.e. desirability scores of 0.
}
\description{
Computing the probability of having desirability scores of zero for each desirability
function applied to an issue.
}
\details{
The function \code{probUnDes} expects an object that results from the \code{\link{getDesScores}}
function. For each issue it computes the probability that it achieves an undesirable score,
i.e. a desirability score of 0. In doing so, it weights the zero desirability scores
with the probability that the sequence occurs.
}
\examples{
# compare Random Allocation Rule to Big Stick Design with respect to different issues
# and their corresponding desirability functions
RAR <- getAllSeq(rarPar(4))
issue1 <- corGuess("CS")
issue2 <- corGuess("DS")
A1 <- assess(RAR, issue1, issue2)

d1 <- derFunc(TV = 0.1, 0.7, 2)
d2 <- derFunc(0.5, c(0.3, 0.8), c(1, 1))
DesScore <- getDesScores(A1, d1, d2, weights = c(5/6, 1/6))

probUnDes(DesScore)


}
\seealso{
Representation of randomization procedures: \code{\link{randPar}}

Generation of randomization sequences: \code{\link{genSeq}}

\code{\link{issues}} for the desirability of randomization sequences

Other desirability topics: 
\code{\link{derFunc}},
\code{\link{evaluate}()},
\code{\link{getDesScores}()},
\code{\link{plotDes}()},
\code{\link{plotEv}()}
}
\concept{desirability topics}
