% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selBias.R
\name{selBias}
\alias{selBias}
\title{Representing selection bias}
\usage{
selBias(type, eta, method, alpha = 0.05)
}
\arguments{
\item{type}{character string, should be one of \code{"CS"}, \code{"CS2"} or \code{"DS"}, see 
Details.}

\item{eta}{numeric specifying the magnitude of selection bias.}

\item{method}{character string, should be one of \code{"sim"} or \code{"exact"}, see 
Details.}

\item{alpha}{significance level.}
}
\value{
\code{S4} object of class \code{selBias}, a formal representation of the
issue of selection bias in a clinical trial.
}
\description{
Represents the issue of selection bias in a clinical trial.
}
\details{
Selection bias can be an issue in the design of a clinical trial. The 
\code{selBias} function is a constructor function
for an S4 object of the class \code{selBias} representing the issue of
third order selection bias in a clinical trial. It supports two possible modes,
\code{method="sim"} and \code{method="exact"}. This representation is 
particularly useful in interaction with the \code{\link{assess}} function. 

\describe{
 \item{\code{method="sim"}}{Represents the simulated type-I-error rate given 
 the level \code{alpha}, the selection effect \code{eta} and the biasing 
 strategy \code{type}. When calling \code{assess} for a \code{selBias} object 
 with \code{method="sim"}, one test decision is computed for each sequence of
\code{randSeq}. The type-I-error rate (power) is the proportion of falsely
(correctly) rejected null hypotheses.
 }
 \item{\code{method="exact"}}{Represents the exact type-I-error proabability 
 given the level \code{alpha}, the selection effect \code{eta} and the 
 biasing strategy \code{type}. When calling \code{assess} for a \code{selBias} 
 object with \code{method="exact"}, the exact \emph{p}-value of each 
 randomization sequence is computed. So far, this is only supported for
 normal endpoints. Then the type-I-error probability is
 the sum of the corresponding quantiles of the doubly noncentral t-distribution.
 }
}
}
\references{
D. Blackwell and J.L. Hodges Jr. (1957) Design for the control of 
selection bias. \emph{Annals of Mathematical Statistics}, \strong{25}, 449-60. 

M. Proschan (1994) Influence of selection bias on the type-I-error rate  
under random permuted block designs. \emph{Statistica Sinica}, \strong{4}, 219-31.
}
\seealso{
Compute exact or simulated type-I-error: \code{\link{assess}}.

Other issues: \code{\link{chronBias}},
  \code{\link{combineBias}}, \code{\link{corGuess}},
  \code{\link{imbal}}, \code{\link{issue}},
  \code{\link{setPower}}
}
