% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hutchpp.R
\name{hutchpp}
\alias{hutchpp}
\title{Hutch++ trace estimation}
\usage{
hutchpp(
  B,
  num_queries = 10,
  sketch_frac = 2/3,
  center = FALSE,
  oraculum = oraculumLi
)
}
\arguments{
\item{B}{An object related to the matrix A for which the trace is to be estimated}

\item{num_queries}{Number of random vectors to draw}

\item{sketch_frac}{Hutch++ detail}

\item{center}{Whether or not to implicitly centre}

\item{oraculum}{The oracle function to use}
}
\value{
An estimate of A's trace - numeric
}
\description{
Hutch++ trace estimation
}
\details{
The Hutch++ algorithm (Meyer et al. 2021, https://doi.org/10.48550/arXiv.2010.09649)
estimates the trace of a matrix A by evaluating matrix
vector products of A and (sub-gaussian) random vectors. This is used on a
matrix B which is related to A through some function. The oracle function has
to be chosen so that oracle(B, G) returns the product A %*% G. By default,
the oracle function is set to work on a pedigree's L inverse matrix. But this
implementation is general and should work - given a custom oracle function -
on other input too.

In the context of pedigree PCA, this is used to estimate the trace of an
(implicitly) centred additive relationship matrix.

There logical parameter center allows for a pedigree's L matrix to be
(implicitly) centred. This is important because centring changes the total
variance of the data and thus the trace of A.
}
\examples{
hutchpp(pedLInv)
hutchpp(pedLInv, center=TRUE)
}
