/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.exponentialfamily;

import eu.amidst.core.distribution.UnivariateDistribution;
import eu.amidst.core.exponentialfamily.EF_UnivariateDistribution;
import eu.amidst.core.exponentialfamily.SufficientStatistics;
import eu.amidst.core.utils.ArrayVector;
import eu.amidst.core.utils.Vector;
import eu.amidst.core.variables.Variable;
import java.util.ArrayList;
import java.util.Random;

public class EF_TruncatedExponential
extends EF_UnivariateDistribution {
    public EF_TruncatedExponential(Variable var1) {
        this.parents = new ArrayList();
        this.var = var1;
        this.naturalParameters = this.createZeroNaturalParameters();
        this.momentParameters = this.createZeroMomentParameters();
        this.naturalParameters.set(0, 0.1);
        this.setNaturalParameters(this.naturalParameters);
    }

    public EF_TruncatedExponential(Variable var1, double initialDelta) {
        this.parents = new ArrayList();
        this.var = var1;
        this.naturalParameters = this.createZeroNaturalParameters();
        this.momentParameters = this.createZeroMomentParameters();
        this.naturalParameters.set(0, initialDelta);
        this.setNaturalParameters(this.naturalParameters);
    }

    @Override
    public double computeLogBaseMeasure(double val) {
        return 0.0;
    }

    @Override
    public SufficientStatistics getSufficientStatistics(double val) {
        SufficientStatistics sufficientStatistics = this.createZeroSufficientStatistics();
        sufficientStatistics.set(0, val);
        return sufficientStatistics;
    }

    @Override
    public Vector getExpectedParameters() {
        return this.momentParameters;
    }

    @Override
    public void fixNumericalInstability() {
    }

    @Override
    public EF_UnivariateDistribution deepCopy(Variable variable) {
        EF_TruncatedExponential copy = new EF_TruncatedExponential(this.var);
        copy.getNaturalParameters().copy(this.getNaturalParameters());
        copy.getMomentParameters().copy(this.getMomentParameters());
        return copy;
    }

    @Override
    public EF_UnivariateDistribution randomInitialization(Random rand) {
        double randomDelta = rand.nextGaussian() * (double)rand.nextInt(100);
        this.getNaturalParameters().set(0, randomDelta);
        this.fixNumericalInstability();
        this.updateMomentFromNaturalParameters();
        return this;
    }

    @Override
    public <E extends UnivariateDistribution> E toUnivariateDistribution() {
        throw new UnsupportedOperationException("TruncatedExponential is not included yet in the Distributions package.");
    }

    @Override
    public void updateNaturalFromMomentParameters() {
        throw new UnsupportedOperationException("Not Implemented");
    }

    @Override
    public void updateMomentFromNaturalParameters() {
        double delta = this.getNaturalParameters().get(0);
        if (Math.exp(delta) > Double.MAX_VALUE) {
            this.momentParameters.set(0, 1.0 - 1.0 / delta);
        } else {
            this.momentParameters.set(0, Math.exp(delta) / (Math.exp(delta) - 1.0) - 1.0 / delta);
        }
    }

    @Override
    public int sizeOfSufficientStatistics() {
        return 1;
    }

    @Override
    public double computeLogNormalizer() {
        double delta = this.getNaturalParameters().get(0);
        return Math.log((Math.exp(delta) - 1.0) / delta);
    }

    @Override
    public Vector createZeroVector() {
        return new ArrayVector(1);
    }

    @Override
    public SufficientStatistics createInitSufficientStatistics() {
        SufficientStatistics sufficientStatistics = this.createZeroSufficientStatistics();
        sufficientStatistics.set(0, 0.1);
        return sufficientStatistics;
    }
}

