% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/instruments.R
\docType{class}
\name{ConvertibleBond-class}
\alias{ConvertibleBond-class}
\alias{ConvertibleBond}
\title{Convertible bond with exercise into stock}
\description{
Convertible bond with exercise into stock
}
\section{Fields}{

\describe{
\item{\code{conversion_ratio}}{The number of shares, per bond, that result from exercise}

\item{\code{dividend_ceiling}}{The level of dividend protection (if any) specified in terms and conditions}
}}

\section{Methods}{

\describe{
\item{\code{exercise_decision(v, S, t, discount_factor_fctn = discount_factor_fcn, ...)}}{Find indexes where hold value {v} will be inferior to conversion value at each stock price level in {S}, adjusted to include all past coupons}

\item{\code{optionality_fcn(v, S, t, discount_factor_fctn = discount_factor_fcn, ...)}}{Return the greater of hold value {v} or exercise value at each stock price level in {S}.  If the given date is beyond maturity, return value at maturity.}

\item{\code{terminal_values(v, ...)}}{Return a terminal value. defaults to simply calling {optionality_fcn}.}

\item{\code{update_cashflows(
  small_t,
  big_t,
  discount_factor_fctn = discount_factor_fcn,
  include_notional = TRUE,
  ...
)}}{Update last_computed_cash and return cashflow information for the given time period, valued at big_t}
}}

