% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dk_correct.R
\name{dk_correct}
\alias{dk_correct}
\title{Correct activity-dependent value based on radioactive decay.}
\usage{
dk_correct(RN_select = NULL, half_life = NULL, time_unit = NULL,
  time_lapse = NULL, date1 = NULL, date2 = Sys.Date(), A1 = 1,
  num = FALSE)
}
\arguments{
\item{RN_select}{identify the radionuclide of interest in the format,
\emph{"Es-254m"} Required unless `half_life` is entered.}

\item{half_life}{Required if `RN_select` is not provided.}

\item{time_unit, }{acceptable values are \emph{"years"}, \emph{"days"},
\emph{"hours"}, \emph{"minutes"}, and \emph{"seconds"}. May be shortened to
\emph{"y"}, \emph{"d"}, \emph{"h"}, \emph{"m"}, and \emph{"s"}. Required if
`half_life` or `time_lapse` are to be entered.}

\item{time_lapse}{a single value or vector of values representing time lapsed
since `date1`, with units identified in `time_unit`. Positive values
represent time past `date1`. Negative values represent time before `date1`.
Required unless `date1` is entered.}

\item{date1}{Reference date - Required unless using `time_lapse`. Format is
required to be date-only: \emph{"YYYY-MM-DD"} (e.g. \emph{"1999-12-31"}).
If `half_life` is short relative to calendar dates, use `time_lapse`
instead.}

\item{date2}{Date or dates of interest. Default is today's date, obtained
from the computer operating system.}

\item{A1}{The reference activity or related parameter, such as count rate or
dose rate. Default value is 1, resulting in a returned value that may be
used as a correction factor.}

\item{num}{Set for TRUE to facilitate as.numeric results. Default = FALSE.}
}
\value{
Decay adjusted activity or related parameter. See `A1`.
}
\description{
Decay-corrected values are provided. Either a single or multiple
  values are computed. The computation is made either based on a single
  radionuclide, or based on user-provided half-life, with time unit. The
  differential time is either computed based on dates entered or time lapsed
  based on the time unit. Time units must be consistent. Decay-correct a
  source to today's date by assigning a reference `date1` and allowing
  default `date2`, the system date.
}
\examples{

# RN_select and date1 (saving numerical data)
my_dks <- dk_correct(
  RN_select = "Sr-90",
  date1 = "2009-01-01",
  date2 = "2019-01-01",
  num = TRUE
)

#   RN_select and time_lapse (random sample)
dk_correct(
  RN_select = base::sample(RadData::ICRP_07.NDX$RN, 1),
  time_lapse = 1:10,
  time_unit = base::sample(c("y", "d", "h", "m", "s"), 1)
)

#   half_life and date1
dk_correct(
  half_life = 10,
  time_unit = "y",
  date1 = "2009-01-01",
  date2 = c(
    "2015-01-01",
    "2016-01-01",
    "2017-01-01"
  )
)

#   half_life and time_lapse
dk_correct(
  half_life = 10,
  time_lapse = 10,
  time_unit = "y"
)

# decay to today
dk_correct(RN_select = "Sr-90", date1 = "2009-01-01")

# reverse decay - find out what readings should have been in the past given today's reading of 3000
dk_correct(
  RN_select = "Sr-90",
  date1 = "2019-01-01",
  date2 = c("2009-01-01", "1999-01-01"),
  A1 = 3000
)
}
\seealso{
Other decay corrections: \code{\link{dk_pct_to_num_half_life}},
  \code{\link{dk_time}}
}
\concept{decay corrections}
