% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radjust.R
\docType{data}
\name{mice}
\alias{mice}
\title{p-values of 29 Behavioural Measures in Two Studies}
\format{A data frame with 29 rows and 5 columns:
\tabular{lll}{
\code{feature_name} \tab char.   \tab The name of the measure and the test, concatenated. \cr
\code{twosided_pv1} \tab numeric \tab the \emph{two-sided} p-value from study 1. \cr
\code{twosided_pv2} \tab numeric \tab the \emph{two-sided} p-value from study 2. \cr
\code{dir_is_left1} \tab logical \tab whether the direction of the test statistic from study 1 is \emph{left}. \cr
\code{dir_is_left2} \tab logical \tab  whether the direction of the test statistic from study 2 is \emph{right}. \cr
}}
\source{
Richter, S. Helene, et al. "Effect of population heterogenization on the reproducibility of mouse behavior:
 a multi-laboratory study." PLoS One 6.1 (2011): e16461.
}
\usage{
mice
}
\description{
In different laboratories, the comparison of behaviours of the same two strains of mice may lead to opposite conclusions that are both statistically significant.
An explanation may be the different laboratory environment, i.e., personnel, equipment, or measurement techniques,
affecting differently the study strains.
This data set provides the p-values for testing the association of mice strain with 29 behavioural measures from five commonly used behavioural tests  in
two laboratories: the laboratory of H. Wurbel at the University of Giessen, and the laboratory of P. Gass at the  Central Institute of Mental Health, Mannheim.
The data table contains two-sided p-values. To transform all the two-sided p-values to one sided in the same direction, see the example in \code{\link{radjust_sym}}.
}
\references{
Bogomolov, M. and Heller, R. (2018). Assessing replicability of findings across two studies of multiple
features. Biometrika.
}
\seealso{
\code{\link{radjust_sym}}
}
\keyword{datasets}
