% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/full_factor.R
\name{full_factor}
\alias{full_factor}
\title{Factor analysis (PCA)}
\usage{
full_factor(dataset, vars, method = "PCA", nr_fact = 1,
  rotation = "varimax", data_filter = "")
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{vars}{Variables to include in the analysis}

\item{method}{Factor extraction method to use}

\item{nr_fact}{Number of factors to extract}

\item{rotation}{Apply varimax rotation or no rotation ("varimax" or "none")}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}
}
\value{
A list with all variables defined in the function as an object of class full_factor
}
\description{
Factor analysis (PCA)
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/full_factor.html} for an example in Radiant
}
\examples{
result <- full_factor("diamonds",c("price","carat","table","x","y"))
result <- full_factor("diamonds",c("price","carat","table","x","y"), method = "maxlik")
result <- diamonds \%>\% full_factor(c("price","carat","table","x","y"), method = "maxlik")

}
\seealso{
\code{\link{summary.full_factor}} to summarize results

\code{\link{plot.full_factor}} to plot results
}
