% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnl.R
\name{store.mnl.predict}
\alias{store.mnl.predict}
\title{Store predicted values generated in the mnl function}
\usage{
\method{store}{mnl.predict}(dataset, object, name = NULL, ...)
}
\arguments{
\item{dataset}{Dataset to add predictions to}

\item{object}{Return value from model function}

\item{name}{Variable name(s) assigned to predicted values. If empty, the levels of the response variable will be used}

\item{...}{Additional arguments}
}
\description{
Store predicted values generated in the mnl function
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/mnl.html} for an example in Radiant
}
\examples{
result <- mnl(
  ketchup,
  rvar = "choice",
  evar = c("price.heinz28", "price.heinz32", "price.heinz41", "price.hunts32"),
  lev = "heinz28"
)
pred <- predict(result, pred_data = ketchup)
ketchup <- store(ketchup, pred, name = c("heinz28", "heinz32", "heinz41", "hunts32"))

}
