% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regress.R
\name{predict.regress}
\alias{predict.regress}
\title{Predict method for the regress function}
\usage{
\method{predict}{regress}(object, pred_data = NULL, pred_cmd = "",
  conf_lev = 0.95, se = TRUE, interval = "confidence", dec = 3, ...)
}
\arguments{
\item{object}{Return value from \code{\link{regress}}}

\item{pred_data}{Provide the dataframe to generate predictions (e.g., diamonds). The dataset must contain all columns used in the estimation}

\item{pred_cmd}{Command used to generate data for prediction}

\item{conf_lev}{Confidence level used to estimate confidence intervals (.95 is the default)}

\item{se}{Logical that indicates if prediction standard errors should be calculated (default = FALSE)}

\item{interval}{Type of interval calculation ("confidence" or "prediction"). Set to "none" if se is FALSE}

\item{dec}{Number of decimals to show}

\item{...}{further arguments passed to or from other methods}
}
\description{
Predict method for the regress function
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/regress.html} for an example in Radiant
}
\examples{
result <- regress(diamonds, "price", c("carat", "clarity"))
predict(result, pred_cmd = "carat = 1:10")
predict(result, pred_cmd = "clarity = levels(clarity)")
result <- regress(diamonds, "price", c("carat", "clarity"), int = "carat:clarity")
predict(result, pred_data = diamonds) \%>\% head()

}
\seealso{
\code{\link{regress}} to generate the result

\code{\link{summary.regress}} to summarize results

\code{\link{plot.regress}} to plot results
}
