% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphic_functions.R
\name{hapDendo}
\alias{hapDendo}
\title{Hierarchical clustering of haplotypes graphical output}
\usage{
hapDendo(
  hap_table,
  chain = c("IGH", "IGK", "IGL", "TRB", "TRA"),
  genes_order = NULL,
  removeIGH = TRUE,
  mark_low_lk = TRUE,
  lk_cutoff = 1
)
}
\arguments{
\item{hap_table}{haplotype summary table. See details.}

\item{chain}{the IG/TR chain: IGH,IGK,IGL,TRB. Default is IGH.}

\item{genes_order}{A vector of the genes by the desired order. Default is by GENE.loc}

\item{removeIGH}{if TRUE, 'IGH'\'IGK'\'IGL' prefix is removed from gene names. Default is TRUE.}

\item{mark_low_lk}{if TRUE, a texture is add for low lK values. Default is TRUE.}

\item{lk_cutoff}{the lK cutoff value to be considerd low for texture layer. Default is lK<1.}
}
\value{
A multitple samples visualization of the distances between haplotypes.
}
\description{
The \code{hapDendo} function generates a graphical output of an hierarchical clustering based on the Jaccard distance between multiple samples' haplotypes.
}
\details{
A \code{data.frame} created by \code{createFullHaplotype}.
}
\examples{
# Plotting haplotype hierarchical clustering based on the Jaccard distance
\donttest{hapDendo(samplesHaplotype)}

}
