% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rTensor_Class.R
\docType{methods}
\name{unfold-methods}
\alias{unfold}
\alias{unfold,Tensor-method}
\alias{unfold-methods}
\title{Tensor Unfolding}
\usage{
unfold(tnsr, row_idx, col_idx)

\S4method{unfold}{Tensor}(tnsr, row_idx = NULL, col_idx = NULL)
}
\arguments{
\item{tnsr}{the Tensor instance}

\item{row_idx}{the indices of the modes to map onto the row space}

\item{col_idx}{the indices of the modes to map onto the column space}
}
\value{
matrix with \code{prod(row_idx)} rows and \code{prod(col_idx)} columns
}
\description{
Unfolds the tensor into a matrix, with the modes in \code{rs} onto the rows and modes in \code{cs} onto the columns. Note that \code{c(rs,cs)} must have the same elements (order doesn't matter) as \code{x@modes}. Within the rows and columns, the order of the unfolding is determined by the order of the modes. This convention is consistent with Kolda and Bader (2009).
}
\details{
For Row Space Unfolding or m-mode Unfolding, see \code{\link{rs_unfold-methods}}. For Column Space Unfolding or matvec, see \code{\link{cs_unfold-methods}}.

\code{\link{vec-methods}} returns the vectorization of the tensor.

\code{unfold(tnsr,row_idx=NULL,col_idx=NULL)}
}
\examples{
tnsr <- rand_tensor()
matT3<-unfold(tnsr,row_idx=2,col_idx=c(3,1))
}
\references{
T. Kolda, B. Bader, "Tensor decomposition and applications". SIAM Applied Mathematics and Applications 2009.
}
\seealso{
\code{\link{k_unfold-methods}} and \code{\link{matvec-methods}}
}

