% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runif_trng.R
\name{runif_trng}
\alias{runif_trng}
\title{Uniform random numbers via TRNG.}
\usage{
runif_trng(n, min = 0, max = 1, engine = NULL, parallelGrain = 0L)
}
\arguments{
\item{n}{Number of observations.}

\item{min, max}{Parameters of the distribution, with the same meaning as in
\code{\link{runif}}. Note however that only scalar values are
accepted.}

\item{engine}{Optional \link[=TRNG.Engine]{TRNG engine object}; if missing or
\code{NULL}, the current engine controlled via \link{TRNG.Random} is used.}

\item{parallelGrain}{Optional argument controlling the parallel simulation of
random variates (see \sQuote{Parallel Simulation} below for details).}
}
\value{
Numeric vector of random variates generated with the given
  parameters. The length is determined by \code{n}.
}
\description{
Random number generation for the uniform distribution
  using the TRNG C++ library.
}
\section{Parallel Simulation}{
 When a positive value of argument
  \code{parallelGrain} is supplied, random variates are simulated in
  parallel, provided a \emph{parallel} random number \code{engine} is
  selected. This is done using \pkg{\link{RcppParallel}} via
  \code{parallelFor}, which uses the supplied \code{parallelGrain} to control
  the grain size (the number of threads being controlled by
  \code{\link{setThreadOptions}}). The grain size can greatly affect the overhead of
  performing the required \emph{block splitting} \code{jump} operations and
  should be selected carefully. Note that TRNG guarantees the outcome of such
  parallel execution to be equivalent to a purely sequential simulation.
}

\examples{
## generate 10 random variates using the current TRNG engine
runif_trng(10, min = 0, max = 1)

## use a TRNG engine reference class object
r <- yarn2$new()
runif_trng(10, min = 0, max = 1, engine = r)

## generate 100k random variates in parallel, with 2 threads and 100 grain size
TRNGseed(117)
RcppParallel::setThreadOptions(numThreads = 2L)
x_parallel <- runif_trng(100e3, min = 0, max = 1, parallelGrain = 100L)
TRNGseed(117)
x_serial <- runif_trng(100e3, min = 0, max = 1)
identical(x_serial, x_parallel)
}
\seealso{
\code{\link{runif}}, \code{\link{TRNG.Engine}},
  \code{\link{TRNG.Random}}.

Other TRNG distributions: \code{\link{rbinom_trng}},
  \code{\link{rlnorm_trng}}, \code{\link{rnorm_trng}},
  \code{\link{rpois_trng}}
}
\concept{TRNG distributions}
