/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import org.python.core.Py;
import org.python.core.PyBuiltinFunctionSet;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.core.__builtin__;
import org.python.util.InteractiveInterpreter;

public class InteractiveConsole
extends InteractiveInterpreter {
    public static final String CONSOLE_FILENAME = "<stdin>";
    public String filename;

    public InteractiveConsole() {
        this(null, CONSOLE_FILENAME);
    }

    public InteractiveConsole(PyObject locals) {
        this(locals, CONSOLE_FILENAME);
    }

    public InteractiveConsole(PyObject locals, String filename) {
        this(locals, filename, false);
    }

    public InteractiveConsole(PyObject locals, String filename, boolean replaceRawInput) {
        super(locals);
        this.filename = filename;
        if (replaceRawInput) {
            PyBuiltinFunctionSet newRawInput = new PyBuiltinFunctionSet("raw_input", 0, 0, 1){

                public PyObject __call__() {
                    return this.__call__(Py.EmptyString);
                }

                public PyObject __call__(PyObject prompt) {
                    return Py.newString(InteractiveConsole.this.raw_input(prompt));
                }
            };
            Py.getSystemState().getBuiltins().__setitem__("raw_input", (PyObject)newRawInput);
        }
    }

    public void interact() {
        this.interact(InteractiveConsole.getDefaultBanner(), null);
    }

    public static String getDefaultBanner() {
        return String.format("Jython %s on %s", PySystemState.version, PySystemState.platform);
    }

    public void interact(String banner, PyObject file) {
        if (banner != null) {
            this.write(banner);
            this.write("\n");
        }
        this.exec("2");
        boolean more = false;
        while (true) {
            String line;
            PyObject prompt = more ? this.systemState.ps2 : this.systemState.ps1;
            try {
                line = file == null ? this.raw_input(prompt) : this.raw_input(prompt, file);
            }
            catch (PyException exc) {
                if (!Py.matchException(exc, Py.EOFError)) {
                    throw exc;
                }
                this.write("\n");
                break;
            }
            more = this.push(line);
        }
    }

    public boolean push(String line) {
        if (this.buffer.length() > 0) {
            this.buffer.append("\n");
        }
        this.buffer.append(line);
        boolean more = this.runsource(this.buffer.toString(), this.filename);
        if (!more) {
            this.resetbuffer();
        }
        return more;
    }

    public String raw_input(PyObject prompt) {
        return __builtin__.raw_input(prompt);
    }

    public String raw_input(PyObject prompt, PyObject file) {
        return __builtin__.raw_input(prompt, file);
    }
}

