/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import org.python.core.BytecodeLoader;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyList;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.core.imp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class importer<T>
extends PyObject {
    final SearchOrderEntry[] searchOrder = this.makeSearchOrder();

    public importer(PyType subType) {
        super(subType);
    }

    public importer() {
    }

    protected abstract String getSeparator();

    protected abstract String makePackagePath(String var1);

    protected abstract String makeFilename(String var1);

    protected abstract String makeFilePath(String var1);

    protected abstract T makeEntry(String var1);

    protected abstract Bundle makeBundle(String var1, T var2);

    private SearchOrderEntry[] makeSearchOrder() {
        return new SearchOrderEntry[]{new SearchOrderEntry(this.getSeparator() + "__init__$py.class", EnumSet.of(EntryType.IS_PACKAGE, EntryType.IS_BYTECODE)), new SearchOrderEntry(this.getSeparator() + "__init__.py", EnumSet.of(EntryType.IS_PACKAGE, EntryType.IS_SOURCE)), new SearchOrderEntry("$py.class", EnumSet.of(EntryType.IS_BYTECODE)), new SearchOrderEntry(".py", EnumSet.of(EntryType.IS_SOURCE))};
    }

    protected final PyObject importer_find_module(String fullname, String path) {
        ModuleInfo moduleInfo = this.getModuleInfo(fullname);
        if (moduleInfo == ModuleInfo.ERROR || moduleInfo == ModuleInfo.NOT_FOUND) {
            return Py.None;
        }
        return this;
    }

    protected final PyObject importer_load_module(String fullname) {
        ModuleCodeData moduleCodeData = this.getModuleCode(fullname);
        if (moduleCodeData == null) {
            return Py.None;
        }
        PyModule mod2 = imp.addModule(fullname);
        mod2.__dict__.__setitem__("__loader__", (PyObject)this);
        if (moduleCodeData.ispackage) {
            PyList pkgpath = new PyList();
            pkgpath.add(this.makePackagePath(fullname));
            mod2.__dict__.__setitem__("__path__", (PyObject)pkgpath);
        }
        imp.createFromCode(fullname, moduleCodeData.code, moduleCodeData.path);
        Py.writeDebug("import", "import " + fullname + " # loaded from " + moduleCodeData.path);
        return mod2;
    }

    protected abstract boolean isAcceptableBytecode(String var1, T var2);

    protected final ModuleInfo getModuleInfo(String fullname) {
        String path = this.makeFilename(fullname);
        for (SearchOrderEntry entry : this.searchOrder) {
            T importEntry = this.makeEntry(path + entry.suffix);
            if (importEntry == null) continue;
            if (entry.type.contains((Object)EntryType.IS_PACKAGE)) {
                return ModuleInfo.PACKAGE;
            }
            return ModuleInfo.MODULE;
        }
        return ModuleInfo.NOT_FOUND;
    }

    protected final ModuleCodeData getModuleCode(String fullname) {
        String path = this.makeFilename(fullname);
        String fullPath = this.makeFilePath(fullname);
        if (path.length() < 0) {
            return null;
        }
        for (SearchOrderEntry entry : this.searchOrder) {
            byte[] codeBytes;
            String suffix = entry.suffix;
            String searchPath = path + suffix;
            String fullSearchPath = fullPath + suffix;
            Py.writeDebug("import", "# trying " + searchPath);
            T tocEntry = this.makeEntry(searchPath);
            if (tocEntry == null) continue;
            boolean ispackage = entry.type.contains((Object)EntryType.IS_PACKAGE);
            boolean isbytecode = entry.type.contains((Object)EntryType.IS_BYTECODE);
            if (isbytecode && !this.isAcceptableBytecode(searchPath, tocEntry)) continue;
            Bundle bundle = this.makeBundle(searchPath, tocEntry);
            if (isbytecode) {
                try {
                    codeBytes = imp.readCode(fullname, bundle.inputStream, true);
                }
                catch (IOException ioe) {
                    throw Py.ImportError(ioe.getMessage() + "[path=" + fullSearchPath + "]");
                }
            } else {
                codeBytes = imp.compileSource(fullname, bundle.inputStream, fullSearchPath);
            }
            bundle.close();
            if (codeBytes == null) continue;
            PyCode code = BytecodeLoader.makeCode(fullname + "$py", codeBytes, fullSearchPath);
            return new ModuleCodeData(code, ispackage, fullSearchPath);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SearchOrderEntry {
        public String suffix;
        public EnumSet<EntryType> type;

        public SearchOrderEntry(String suffix, EnumSet<EntryType> type) {
            this.suffix = suffix;
            this.type = type;
        }
    }

    protected class ModuleCodeData {
        public PyCode code;
        public boolean ispackage;
        public String path;

        public ModuleCodeData(PyCode code, boolean ispackage, String path) {
            this.code = code;
            this.ispackage = ispackage;
            this.path = path;
        }
    }

    protected static abstract class Bundle {
        public InputStream inputStream;

        public Bundle(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public abstract void close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ModuleInfo {
        ERROR,
        NOT_FOUND,
        MODULE,
        PACKAGE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EntryType {
        IS_SOURCE,
        IS_BYTECODE,
        IS_PACKAGE;

    }
}

