% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stationary1d.R
\name{update.rSPDEobj1d}
\alias{update.rSPDEobj1d}
\title{Update parameters of rSPDEobj1d objects}
\usage{
\method{update}{rSPDEobj1d}(
  object,
  nu = NULL,
  alpha = NULL,
  kappa = NULL,
  tau = NULL,
  sigma = NULL,
  range = NULL,
  theta = NULL,
  m = NULL,
  loc = NULL,
  graph = NULL,
  parameterization = NULL,
  type_rational_approximation = object$type_rational_approximation,
  ...
)
}
\arguments{
\item{object}{The covariance-based rational SPDE approximation,
computed using \code{\link[=matern.rational]{matern.rational()}}}

\item{nu}{If non-null, update the shape parameter of the
covariance function. Will be used if parameterization is 'matern'.}

\item{alpha}{If non-null, update the fractional SPDE order parameter. Will be used if parameterization is 'spde'.}

\item{kappa}{If non-null, update the parameter kappa of the SPDE. Will be used if parameterization is 'spde'.}

\item{tau}{If non-null, update the parameter tau of the SPDE. Will be used if parameterization is 'spde'.}

\item{sigma}{If non-null, update the standard deviation of
the covariance function. Will be used if parameterization is 'matern'.}

\item{range}{If non-null, update the range parameter
of the covariance function. Will be used if parameterization is 'matern'.}

\item{theta}{For non-stationary models. If non-null, update the vector of parameters.}

\item{m}{If non-null, update the order of the rational
approximation, which needs to be a positive integer.}

\item{loc}{The locations of interest for evaluating the model.}

\item{graph}{An optional \code{metric_graph} object.}

\item{parameterization}{If non-null, update the parameterization.}

\item{type_rational_approximation}{Which type of rational
approximation should be used? The current types are "chebfun",
"brasil" or "chebfunLB".}

\item{...}{Currently not used.}
}
\value{
It returns an object of class "rSPDEobj1d". This object contains the
same quantities listed in the output of \code{\link[=matern.rational]{matern.rational()}}.
}
\description{
Function to change the parameters of a rSPDEobj1d object
}
\examples{

s <- seq(from = 0, to = 1, length.out = 101)
kappa <- 20
sigma <- 2
nu <- 0.8
r <- sqrt(8*nu)/kappa #range parameter
op_cov <- matern.rational(loc = s, nu = nu, range = r, sigma = sigma, m = 2, 
parameterization = "matern")
cov1 <- op_cov$covariance(ind = 1)
op_cov <- update(op_cov, range = 0.2)
cov2 <- op_cov$covariance(ind = 1)
plot(s, cov1, type = "l")
lines(s, cov2, col = 2)
}
\seealso{
\code{\link[=simulate.rSPDEobj1d]{simulate.rSPDEobj1d()}}, \code{\link[=matern.rational]{matern.rational()}}
}
