% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceSHAPE.R
\name{querryEstablished}
\alias{querryEstablished}
\title{This function is used to find which elements of a population matrix are deemed as established.  Established is determined
by having a number of individuals greater than or equal to a definable proportion of the summed community size.}
\usage{
querryEstablished(func_inMatrix, func_sizeCol = "popSize",
  func_fitCol = "fitness", func_estProp = 0.01)
}
\arguments{
\item{func_inMatrix}{This is a matrix which must contain at least one column named as func_sizeCol which contains
the number of individuals in the communities' populations.  But it may also be required to include a column
func_fitCol if func_estProp is "Desai".}

\item{func_sizeCol}{DO NOT MODIFY - this is the column name that is querried to find population sizes}

\item{func_fitCol}{DO NOT MODIFY - this is the column name that is querried to find population fitness -
only important if func_estProp is set to "Desai"}

\item{func_estProp}{If this value is less than 1 - This is the proportion of the current community size which
is used to define a population as established it returns the rows of.  If this value is greater than 1, it is
the minimum number of individuals required before a population is considered as established.
Lastly, it can be the character string "Desai", at which point - as per Desai 2007 - a lineage is established
once it has 1/s individuals.}
}
\value{
A subset form of the input func_inMatrix matrix object containing the populations which are calculated
as established.
}
\description{
This function is used to find which elements of a population matrix are deemed as established.  Established is determined
by having a number of individuals greater than or equal to a definable proportion of the summed community size.
}
\section{Note}{

There is no example as this cannot work outisde of a runSHAPE call, it requires data produced by the simulation experiment.
}

