% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceSHAPE.R
\name{compute_distGrowth}
\alias{compute_distGrowth}
\title{This function is used to calculate the effect size and timing of the next stochastic population disturbance in a SHAPE run.}
\usage{
compute_distGrowth(func_distFactor, func_growthType, func_distType,
  func_growthRate, func_popSize, func_focalSize,
  func_manualGenerations = NULL, func_stepDivs)
}
\arguments{
\item{func_distFactor}{This is the expected effect size of the disturbance, it should be a named vector with elements
\strong{factor, random} which are each used as per the func_distType}

\item{func_growthType}{This is the growth model of the SHAPE run}

\item{func_distType}{This is the type of disturbance to be simulated.  Currently I've implemented
\strong{bottleneck, random} options for constant bottlenecks or normally distributed random effect sizes}

\item{func_growthRate}{This is the basal growth rate of the SHAPE run}

\item{func_popSize}{This is a vector of the number of individuals in each of the populations}

\item{func_focalSize}{This only matters if the growth model is exponential in which case the disturbance
is always such that the community size is reduced to the func_focalSize value}

\item{func_manualGenerations}{If not NULL, it will be rounded to an integer value and taken as the manually
controlled number of generations between disturbances.  Otherwise, the disturbance factor and growth rate are
used to estimate the number of steps required for a community with relative fitness 1 to rebound.}

\item{func_stepDivs}{This is the value that controls what proportion of a standard biological "generation" is
simulated in each step of a SHAPE run.}
}
\value{
A named vector with three elements describing the simulated reduction factor of populations,
the number of individuals lost, and the number of steps estimated until the next disturbance.
}
\description{
This function is used to calculate the effect size and timing of the next stochastic population disturbance in a SHAPE run.
}
\examples{
# This calculates the information for the next planned stochastic disturbance event.
# Consider a situation where there is a disturbance reducing populations 100 fold,
# and it occurs either in a proscriptive number of steps, or we calculate it based
# on recovery time as per the growth rate and growth model parameters.
compute_distGrowth("bottleneck","exponential","bottleneck",
                     2,1e4,1e2,5,1)
compute_distGrowth("bottleneck","exponential","bottleneck",
                   2,1e4,1e2,NULL,1)
# If growth is constant or Poisson, then disturbances are effectively supressed
compute_distGrowth("bottleneck","poisson","bottleneck",
                   2,1e4,1e2,NULL,1)

}
