% Generated by roxygen2 (4.0.1): do not edit by hand
\name{sfa2}
\alias{sfa2}
\title{The SFA2 algorithm, SFA with degree 2 expansion.}
\usage{
sfa2(x, method = "SVDSFA", ppType = "PCA", xpDimFun = xpDim,
  sfaExpandFun = sfaExpand)
}
\arguments{
\item{x}{input data}

\item{method}{eigenvector calculation method:    ="SVDSFA" for singular value decomposition (recommended) or
 ="GENEIG" for generalized eigenvalues (unstable!).    GENEIG is not implemented in the current version, since
R lacks an easy option to calculate generalized eigenvalues.}

\item{ppType}{preprocessing type: ="PCA" (principal component analysis) or ="SFA1" (linear sfa)}

\item{xpDimFun}{function to calculate dimension of expanded data}

\item{sfaExpandFun}{function to expand data}
}
\value{
list \code{sfaList} with all SFA information, among them are
   \item{\code{y}}{ a matrix containing  the output Y (as described above) }
   \item{-}{ all input parameters to \code{\link{sfa2Create}}  }
   \item{-}{ all elements of \code{sfaList}  as specified in \code{\link{sfa2Step}}}
}
\description{
Y = sfa2(X) performs expanded Slow Feature Analysis on the input data
   X and returns the output signals Y ordered by increasing temporal
   variation, i.e. the first signal Y[,1] is the slowest varying one,
   Y[,2] the next slowest varying one and so on. The input data have to
   be organized with each variable in a column and each data (time) point in a
   row, i.e. X(t,i) is the value of variable i at time t.
	  By default an expansion to the space of 2nd degree polynomials is done,
	  this can be changed by using different functions for xpDimFun and sfaExpandFun.
}
\examples{
## prepare input data for simple demo
t=seq.int(from=0,by=0.011,to=2*pi)
x1=sin(t)+cos(11*t)^2
x2=cos(11*t)
x=data.frame(x1,x2)
## perform sfa2 algorithm with data
res = sfa2(x)
## plot slowest varying function of result
plot(t, res$y[,1],type="l",main="output of the slowest varying function")
## see http://www.scholarpedia.org/article/Slow_feature_analysis#The_algorithm
## for detailed description of this example
}
\seealso{
\code{\link{sfa2Step}} \code{\link{sfa2Create}} \code{\link{sfaExecute}} \code{\link{sfa1}}
}

