% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tg.R
\name{tg.plot}
\alias{tg.plot}
\title{tg.plot}
\usage{
tg.plot(
  tg,
  group = "",
  pt = NULL,
  it = NULL,
  formant = NULL,
  formantScaleIntensity = TRUE,
  formantDrawBandwidth = TRUE,
  pitch = NULL,
  pitchScaleIntensity = TRUE,
  pitchShowStrength = FALSE,
  snd = NULL
)
}
\arguments{
\item{tg}{TextGrid object}

\item{group}{[optional] character string, name of group for dygraphs synchronization}

\item{pt}{[optional] PitchTier object}

\item{it}{[optional] IntensityTier object}

\item{formant}{[optional] Formant object}

\item{formantScaleIntensity}{[optional] Point size scaled according to relative intensity}

\item{formantDrawBandwidth}{[optional] Draw formant bandwidth}

\item{pitch}{[optional] Pitch object}

\item{pitchScaleIntensity}{[optional] Point size scaled according to relative intensity}

\item{pitchShowStrength}{[optional] Show strength annotation}

\item{snd}{[optional] Sound object}
}
\description{
Plots interactive TextGrid using \code{dygraphs} package.
}
\examples{
\dontrun{
tg <- tg.sample()
tg.plot(tg)
tg.plot(tg.sample(), pt = pt.sample())
}
}
\seealso{
\code{\link{tg.read}}, \code{\link{pt.plot}}, \code{\link{it.plot}}, \code{\link{pitch.plot}}
}
