% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_property.R
\name{add_property}
\alias{add_property}
\title{Add or Merge Properties for RCSB PDB Data Fetching}
\usage{
add_property(property)
}
\arguments{
\item{property}{A dictionary where keys are the properties (like 'cell', 'exptl') and
values are lists of subproperties (like 'volume', 'angle_beta', 'method').
Each subproperty should be in character vector format. Full list of properties can be found at https://data.rcsb.org/#data-schema.}
}
\value{
A modified list with updated properties where subproperties are merged if a property already exists.
}
\description{
This function is designed for handling properties related to fetching data from the Protein Data Bank (PDB).
It takes a dictionary, where keys represent properties and values are lists of subproperties.
If a property already exists in the input list, the function merges the subproperties,
ensuring each subproperty is unique and maintains character vector format.
}
\examples{
properties <- list(cell = c("length_a", "length_b", "length_c"), exptl = c("method"))
add_property(properties)
}
