% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotSingleCornea}
\alias{plotSingleCornea}
\title{Plot the corneal topography and a summary plot of the Placido irregularity indices}
\usage{
plotSingleCornea(dataset, PlacidoIndices, filename = NULL)
}
\arguments{
\item{dataset}{A \code{data.frame} containing the corneal topography points, with columns:
\tabular{lll}{
  \code{x}   \tab\tab The X Cartesian coordinates of the points\cr
  \code{y}   \tab\tab The Y Cartesian coordinates of the points\cr
  \code{ring index}  \tab\tab Number or index of the ring to which each point belongs\cr
}}

\item{PlacidoIndices}{A dataset of results as given by the function \link[rPACI]{computePlacidoIndices} or \link[rPACI]{analyzeFile}.}

\item{filename}{An optional character argument, with the file name used to read the data (by default, \code{NULL}; if specified, the filename is displayed on the plot).}
}
\description{
Draw a three-part plot summarizing the corneal topography analysis, based on the Placido irregularity
indices calculated by the function \link[rPACI]{computePlacidoIndices}
}
\details{
This function draws a 3-column plot, with the corneal topography in \code{dataset} plotted on the left, 
the value of index GLPI taken from \code{PlacidoIndices} on the middle, and a boxplot of some of the 
Placido indices on the right (with the values of PI_1, PI_2, PI_3 and SL) taken from \code{PlacidoIndices}.

For the two latter columns, the ranges of values that should be considered normal, suspect or irregular
have been depicted with different colors (green, orange and red respectively). The thresholds for these
divisions are 30 (between normal (green) and suspect (orange) zones) and 70 (between suspect (orange) 
and irregular (red) zones). 

The scales for these two plots are in general different, as GLPI ranges from 0 to 100, whereas the 
primary Placido irregularity indices range from 0 to 150 by default.

Consult more information about the use of \code{rPACI}, including the available plots, 
in \href{../doc/packageUsage.html}{\code{vignette("packageUsage", package = "rPACI")}},
}
\examples{
# Read a corneal topography from a file
dataset = readFile(system.file("extdata","K03.txt", package="rPACI"))

# Compute the Placido irregularity indices with:
results = computePlacidoIndices(dataset)

# Draw the corneal topography along the results with:
plotSingleCornea(dataset, results)
}
