% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_neiprob.R
\name{calc_neiprob}
\alias{calc_neiprob}
\title{Calculating a set of neighbor QTL effects from conditional genotype probabilities}
\usage{
calc_neiprob(
  genoprobs,
  a2,
  d2,
  contrasts = c(TRUE, TRUE, TRUE),
  smap,
  scale,
  grouping = rep(1, nrow(smap)),
  d2sq0 = FALSE
)
}
\arguments{
\item{genoprobs}{Conditional genotype probabilities as taken from \code{qtl::calc.genoprob()}.}

\item{a2}{A numeric scalar indicating additive deviation.}

\item{d2}{A numeric scalar indicating dominance deviation.}

\item{contrasts}{A vector composed of three TRUE/FALSE values, which represents the presence/absence of specific genotypes as c(TRUE/FALSE, TRUE/FALSE, TRUE/FALSE) = AA, AB, BB.}

\item{smap}{A matrix showing a spatial map for individuals. The first and second column include spatial positions along an x-axis and y-axis, respectively.}

\item{scale}{A numeric scalar indicating the maximum spatial distance between a focal individual and neighbors to define neighbor effects.}

\item{grouping}{An integer vector assigning each individual to a group. This argument can be used when \code{smap} contains different experimental replicates. Default setting means that all individuals are belong to a single group.}

\item{d2sq0}{An option to make AB/AB interaction effects zero.}
}
\value{
A numeric matrix containing individuals x marker elements for neighbor QTL effects.
}
\description{
A function to calculate self QTL effects for all individuals, with given deviation coefficients and conditional genotype probabilities.
}
\author{
Yasuhiro Sato (\email{sato.yasuhiro.36c@kyoto-u.jp})
}
