% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nei_lmm.R
\name{nei_lmm}
\alias{nei_lmm}
\title{Mixed models for testing self and neighbor effects}
\usage{
nei_lmm(
  geno,
  g_nei,
  pheno,
  addcovar = NULL,
  response = c("quantitative", "binary"),
  n_core = 1L,
  asym = FALSE
)
}
\arguments{
\item{geno}{An individual x marker matrix. Bialleles (i.e., A or a) must be converted into -1 or 1 digit.}

\item{g_nei}{An output of \code{nei_coval()} object, namely an individual x marker matrix including neighbor genotypic identity.}

\item{pheno}{A numeric vector including phenotypes for individuals}

\item{addcovar}{An optional matrix including additional non-genetic covariates. It contains no. of individuals x no. of covariates.}

\item{response}{An option to select if the phenotype is a \code{"quantitative"} trait subject to linear models, or a \code{"binary"} trait subject to logistic models.}

\item{n_core}{No. of cores for a multi-core computation. This does not work for Windows OS. Default is a single-core computation.}

\item{asym}{If TRUE, asymmetric neighbor effects are also tested and returned as "beta_sxn" and "p_sxn".}
}
\value{
A data.frame including coefficients and p-values of self and neighbor effects, without the chromosome numbers and marker position.
\itemize{
\item{\code{beta_self}} {coefficient for self effects}
\item{\code{beta_self}} {coefficient for neighbor effects}
\item{\code{p_self}} {p-value for self effects by a likelihood ratio test between a null and standard GWAS model}
\item{\code{p_nei}} {p-value for neighbor effects by a likelihood ratio test between models with or without neighbor effects}
}
}
\description{
A function to provide coefficients and p-values of self and neighbor effects for each marker.
}
\details{
This function is a subset of \code{neiGWAS()}. \code{nei_lmm()} gives detailed results but requires more computational time.
}
\seealso{
\code{\link{neiGWAS}}
}
\author{
Yasuhiro Sato (\email{sato.yasuhiro.36c@kyoto-u.jp})
}
