% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotKIN.R
\name{plotKIN}
\alias{plotKIN}
\title{Plotting function for rKIN polygons}
\usage{
plotKIN(
  estObj,
  scaler = 1,
  alpha = 0.3,
  title = "",
  xlab = "x",
  ylab = "y",
  xmin = NULL,
  xmax = NULL,
  ymin = NULL,
  ymax = NULL
)
}
\arguments{
\item{estObj}{list object created from estKIN, estMCP or estEllipse functions}

\item{scaler}{numeric value indicating number of isotopic units to expand the x and y axes of the plot. Default is 1.}

\item{alpha}{numeric value between 0 and 1, representing the amount of transparency of each polygon. 0 is transparent, 1 is opaque.}

\item{title}{character string for a plot title.}

\item{xlab}{character or expression string for the x-axis label.}

\item{ylab}{character or expression string for the y-axis label.}

\item{xmin}{default is NULL, numeric value of user specified minimum x axis value}

\item{xmax}{default is NULL, numeric value of user specified maximum x axis value}

\item{ymin}{default is NULL, numeric value of user specified minimum y axis value}

\item{ymax}{default is NULL, numeric value of user specified maximum y axis value}
}
\value{
A plot of all groups and levels.
}
\description{
Using ggplot2 methods, simultaneously plot all of the groups and levels of niche space
}
\examples{
library(rKIN)
data("rodents")
#estimate niche overlap between 2 species using kernel UD
test.kin<- estKIN(data=rodents, x="Ave_C", y="Ave_N", group="Species",
                   levels=c(50, 75, 95), scaler=2)
#determine polygon overlap for all polygons
plotKIN(test.kin, scaler = 1, title = "Kernel Estimates",
         xlab = expression({delta}^13*C~ ('\u2030')),
         ylab = expression({delta}^15*N~ ('\u2030')))
}
\author{
Shannon E. Albeke, Wyoming Geographic Information Science Center, University of Wyoming
}
