% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_08_fit_linERR_ef.r
\name{f_fit_linERR_ef}
\alias{f_fit_linERR_ef}
\title{fit Excess Relative Risk Model}
\usage{
f_fit_linERR_ef(formula, data, id_name, dose_name, time_name, covars_names, lag,
  exclusion_done = F)
}
\arguments{
\item{formula}{Surv(entry_time,exit_time,outcome)~loglin(loglin_var1,..,loglin_varn)+\cr
lin(lin_var1,..,lin_varm)+strata(strat_var1,...strat_varp)}

\item{data}{data set returned from f_to_model_data}

\item{id_name}{name of variable containing the names of subjects}

\item{dose_name}{name of variable containing the doses at each time}

\item{time_name}{name of the time variable}

\item{covars_names}{a character vector with the names of the variables used as covariates in the fomrula (adjustments and stratification)}

\item{lag}{latency period}

\item{exclusion_done}{a logical indicating wheather the exclusion is already done or not}
}
\value{
rERR object with the estimation
}
\description{
function that calls the optimization (mle from stats4 package, so use optim) from an event format data set, and return a rERR object with the estimation and summary
}
\examples{
# set the formulas for the models
formula1  <- Surv(entry_age,exit_age,outcome) ~ lin(dose_cum) + strata(sex)
formula2  <- Surv(entry_age,exit_age,outcome) ~ loglin(factor(country)) + lin(dose_cum) +
                                                strata(sex)

# fit the models
fit1 <- f_fit_linERR_ef(formula1,data=cohort_ef,id_name="id",dose_name="dose",
                        time_name="age",covars_names=c("sex"),lag=2,exclusion_done=TRUE)
fit2 <- f_fit_linERR_ef(formula2,data=cohort_ef,id_name="id",dose_name="dose",
                        time_name="age",covars_names=c("sex","country"),lag=2,exclusion_done=TRUE)

# display a summary
summary(fit1)
summary(fit2)

# confidence intervals
confint(fit1)
confint(fit2)

# likelihood ratio test between nested and nesting models
f_lrt(fit1,fit2)
}
