% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_transformations.R
\name{make_twin_idx}
\alias{make_twin_idx}
\title{Generate a time index for a twin surrogate}
\usage{
make_twin_idx(twins, phase_lock = TRUE, T_period = 24,
  initial_point = "same_season")
}
\arguments{
\item{twins}{a list of the twins. The list has length equal to the time 
series, and each element is a vector of the candidate twins. See 
\code{\link{identify_twins}}.}

\item{phase_lock}{whether twins have to occur at the same phase}

\item{T_period}{the period of seasonality for seasonal surrogates 
(ignored for other methods)}

\item{initial_point}{how to sample the initial point. If `"same_season"`, 
then the initial point is chosen from the same phase in a different cycle, 
and the surrogate is not allowed to line up in both phase and cycle with 
the original time series.}
}
\value{
A vector of the same length as the original time series (here, 
  `length(twins)`) and containing the reordered time indices.
}
\description{
Use the `twins` recurrence structure to construct a surrogate 
  time series. Note that we don't use the values of the actual time series, 
  but instead use the time series index (the surrogate is a reordered set of 
  points, with possible duplicates). This is easier for the code, as the 
  method is agnostic to the actual time series anyway, since it only cares 
  about the twins.
}
\details{
Suppose that the original time series is x, and the surrogate is s. 
  The algorithm supposes that the j-th value in s is the m-th value of x. 
  For the initial point (j = 1), we sample from either the twins of x, or 
  the same phase point in other cycles (depending on the `initial_point` 
  argument).
  Then, at each next value of j, we sample from the possible twins of x(m), 
  with the following conditions:
    (i) the selected twin of m cannot be the last point in the time series
    (ii) if `initial_point = "same_season"`, then the selected twin of m 
         cannot be j
  If these are met, then s(j+1) = x(m+1), and we continue.
}
