% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ChartScrollbar.R
\docType{methods}
\name{initialize,ChartScrollbar-method}
\alias{chartScrollbar}
\alias{initialize,ChartScrollbar-method}
\alias{setGraph,ChartScrollbar-method}
\alias{setUpdateOnReleaseOnly}
\alias{setUpdateOnReleaseOnly,ChartScrollbar,logical-method}
\title{Initialize a ChartScrollbar}
\usage{
\S4method{initialize}{ChartScrollbar}(.Object, graph,
  pathToImages = "http://www.amcharts.com/lib/3/images/", updateOnReleaseOnly,
  ...)

chartScrollbar(graph, pathToImages = "http://www.amcharts.com/lib/3/images/",
  updateOnReleaseOnly, ...)

\S4method{setGraph}{ChartScrollbar}(.Object, graph = NULL, ...)

setUpdateOnReleaseOnly(.Object, updateOnReleaseOnly)

\S4method{setUpdateOnReleaseOnly}{ChartScrollbar,logical}(.Object,
  updateOnReleaseOnly)
}
\arguments{
\item{.Object}{\linkS4class{ChartScrollbar}.}

\item{graph}{\linkS4class{AmGraph}.
Specifies which graph will be displayed in the scrollbar.}

\item{pathToImages}{\code{character} URL to API images (for buttons)}

\item{updateOnReleaseOnly}{\code{logical}.
Specifies if the chart should be updated while dragging/resizing the scrollbar
or only at the moment when user releases mouse button.}

\item{...}{Other preperties
See \url{http://docs.amcharts.com/3/javascriptcharts/ChartScrollbar}}
}
\description{
Initialize a ChartScrollbar
}
\section{Functions}{
\itemize{
\item \code{chartScrollbar}: 
}}
\examples{
new("ChartScrollbar", graph = "g1")
new("ChartScrollbar", graph = amGraph(test = 1))
chartScrollbar()
chartScrollbar(updateOnReleaseOnly = TRUE)
setGraph(.Object = chartScrollbar(), test = 1)
setUpdateOnReleaseOnly(.Object = chartScrollbar(), updateOnReleaseOnly = TRUE)
}

