% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ChartScrollbar.R, R/ChartScrollbar_setters.R
\docType{methods}
\name{initialize,ChartScrollbar-method}
\alias{chartScrollbar}
\alias{chartScrollbarSettings}
\alias{initialize,ChartScrollbar-method}
\alias{setEnabled}
\alias{setEnabled,ChartScrollbar,logical-method}
\alias{setGraph,ChartScrollbar,AmGraphOrCharacterOrMissing-method}
\title{Initialize a ChartScrollbar}
\usage{
\S4method{initialize}{ChartScrollbar}(.Object, graph, enabled, ...)

chartScrollbar(graph, enabled = TRUE, ...)

chartScrollbarSettings(graph, enabled = TRUE, ...)

\S4method{setGraph}{ChartScrollbar,AmGraphOrCharacterOrMissing}(.Object,
  graph = NULL, ...)

setEnabled(.Object, enabled)

\S4method{setEnabled}{ChartScrollbar,logical}(.Object, enabled)
}
\arguments{
\item{.Object}{\linkS4class{ChartScrollbar}.}

\item{graph}{\linkS4class{AmGraph}.
Specifies which graph will be displayed in the scrollbar.}

\item{enabled}{\code{logical}.
Specifies if the chart should be updated while dragging/resizing the scrollbar
or only at the moment when user releases mouse button.}

\item{...}{Other preperties
See \url{http://docs.amcharts.com/3/javascriptcharts/ChartScrollbar}}
}
\description{
Initialize a ChartScrollbar

ChartScrollbarSettings settings set's settings for chart scrollbar.
If you change a property after the chart is initialized,
you should call stockChart.validateNow() method in order for it to work.
If there is no default value specified, default value of ChartScrollbar class will be used.
Run \code{api("ChartScrollbarSettings")} for more information.
}
\section{Functions}{
\itemize{
\item \code{chartScrollbar}: 

\item \code{chartScrollbarSettings}: 
}}
\examples{
new("ChartScrollbar", graph = "g1")
new("ChartScrollbar", graph = amGraph(test = 1))
chartScrollbar()
chartScrollbar(enabled = TRUE)
chartScrollbar()
chartScrollbar(enabled = TRUE)
# chartScrollbar with default graph
setGraph(.Object = chartScrollbar())

# example with arguments
setGraph(.Object = chartScrollbar(), id = "graph1", balloonText = "performance")
# equivalent to:
graph_obj <- amGraph(id = "graph1", balloonText = "performance")
(chartScrollbar_obj <- setGraph(.Object = chartScrollbar(), graph = graph_obj))
# or, iff graph_obj has alreadey been added to the chart:
setGraph(.Object = chartScrollbar(), graph = "graph1")
\dontshow{
print(chartScrollbar_obj)
}
# ---
setEnabled(.Object = chartScrollbar(), enabled = TRUE)
}

