% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style.R
\name{m_style_stick}
\alias{m_style_stick}
\title{Specify Styling for Stick}
\usage{
m_style_stick(
  radius = 0.4,
  singleBonds = FALSE,
  colorScheme = "default",
  color = NULL,
  opacity = 1,
  hidden = FALSE
)
}
\arguments{
\item{radius}{Radius of sticks.}

\item{singleBonds}{Draw all bonds as single bonds if \code{TRUE}.}

\item{colorScheme}{Specify scheme to color the atoms by. Default is
"default". Other choies are "Carbon", ssPyMOL", "ssJmol", "Jmol",
"default", "amino",
"shapely", "nucleic", "chain", "chainHetatm", "prop".}

\item{color}{Fixed coloring, overrides colorScheme.}

\item{opacity}{Opacity, must be the same for all atoms in the model.}

\item{hidden}{Do not show.}
}
\description{
Styling options for the stick representation. Used inside
\code{m_add_style()} and \code{m_set_style()}.
}
\examples{
r3dmol() \%>\%
  m_add_model(data = pdb_1j72, format = "pdb") \%>\%
  m_set_style(style = m_style_stick(opacity = 0.4)) \%>\%
  m_zoom_to()
}
