% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisq_test.R
\name{chisq_test}
\alias{chisq_test}
\alias{to_SPSS.chisq_test_SPSS}
\alias{print.chisq_test_SPSS}
\alias{chisqTest}
\title{\eqn{\chi^{2}}{Chi-squared} Tests}
\usage{
chisq_test(data, variables, p = NULL)

\method{to_SPSS}{chisq_test_SPSS}(
  object,
  statistics = c("test", "frequencies"),
  version = r2spss_options$get("version"),
  digits = c(1, 3),
  ...
)

\method{print}{chisq_test_SPSS}(
  x,
  statistics = c("frequencies", "test"),
  version = r2spss_options$get("version"),
  digits = c(1, 3),
  ...
)

chisqTest(data, variables, p = NULL)
}
\arguments{
\item{data}{a data frame containing the variables.}

\item{variables}{a character vector specifying the categorical variable(s)
of interest.  If only one variable is specified, a goodness-of-fit test is
performed.  If two variables are specified, a test on independence is
performed (with the first variable used for the rows and the second variable
for the columns of the crosstabulation).}

\item{p}{a vector of probabilities for the categories in the
goodness-of-fit test.}

\item{object, x}{an object of class \code{"chisq_test_SPSS"} as returned by
function \code{chisq_test}.}

\item{statistics}{a character string or vector specifying which SPSS tables
to produce.  Available options are \code{"frequencies"} for a table of the
observed and expected frequencies, and \code{"test"} for test results.  For
the \code{to_SPSS} method, only one option is allowed (the default is the
table of test results), but the \code{print} method allows several options
(the default is to print all tables).}

\item{version}{a character string specifying whether the table should
mimic the content and look of recent SPSS versions (\code{"modern"}) or
older versions (<24; \code{"legacy"}).  The main difference in terms of
content is that small p-values are displayed differently.}

\item{digits}{an integer vector giving the number of digits after the comma
to be printed in the SPSS tables.  The first element corresponds to the
number of digits for the expected frequencies, and the second element
corresponds to the number of digits in the table for the test.}

\item{\dots}{additional arguments to be passed down to
\code{\link{format_SPSS}}.}
}
\value{
An object of class \code{"chisq_test_SPSS"} with the following components:
\describe{
  \item{\code{chisq}}{a list containing the results of the
  \eqn{\chi^{2}}{chi-squared} test.}
  \item{\code{lr}}{a list containing the results of a likelihood ratio
  test (only test on independence).}
  \item{\code{observed}}{a table containing the observed frequencies.}
  \item{\code{expected}}{a vector or matrix containing the expected
  frequencies.}
  \item{\code{n}}{an integer giving the number of observations.}
  \item{\code{k}}{an integer giving the number of groups (only
  goodness-of-fit test).}
  \item{\code{r}}{an integer giving the number of groups in the first
  variable corresponding to the rows (only test on independence).}
  \item{\code{c}}{an integer giving the number of groups in the second
  variable corresponding to the columns (only test on independence).}
  \item{\code{variables}}{a character vector containing the name(s) of the
  categorical variable(s) of interest.}
  \item{\code{type}}{a character string giving the type of
  \eqn{\chi^{2}}{chi-squared} test performed (\code{"goodness-of-fit"}
  or \code{"independence"}).}
}

The \code{to_SPSS} method returns an object of class \code{"SPSS_table"}
which contains all relevant information in the required format to produce
the LaTeX table.  See \code{\link{to_latex}} for possible components and
how to further customize the LaTeX table based on the returned object.

The \code{print} method produces a LaTeX table that mimics the look of SPSS
output.
}
\description{
Perform a \eqn{\chi^{2}}{chi-squared} goodness-of-fit test or a
\eqn{\chi^{2}}{chi-squared} test on independence on variables of
a data set.  The output is printed as a LaTeX table that mimics
the look of SPSS output.
}
\details{
The \code{print} method first calls the \code{to_SPSS} method followed
by \code{\link{to_latex}}.  Further customization can be done by calling
those two functions separately, and modifying the object returned by
\code{to_SPSS}.
}
\note{
The test on independence also reports the results of a likelihood
ratio test.

LaTeX tables that mimic recent versions of SPSS (\code{version = "modern"})
may require several LaTeX compilations to be displayed correctly.
}
\examples{
# load data
data("Eredivisie")

# test whether the traditional Dutch 4-3-3 (total football)
# is still reflected in player composition
chisq_test(Eredivisie, "Position", p = c(1, 4, 3, 3)/11)

# test whether playing position and dummy variable for
# foreign players are independent
chisq_test(Eredivisie, c("Position", "Foreign"))

}
\author{
Andreas Alfons
}
\keyword{htest}
