/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.visitors;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.jpmml.model.MarkupException;
import org.jpmml.model.MisplacedAttributeException;
import org.jpmml.model.MisplacedElementException;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.model.UnsupportedAttributeException;
import org.jpmml.model.UnsupportedElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.Removed;
import org.jpmml.model.annotations.Required;
import org.jpmml.model.visitors.Resettable;
import org.jpmml.model.visitors.VersionInspector;

public class VersionChecker
extends VersionInspector
implements Resettable {
    private Version version = null;
    private List<MarkupException> exceptions = new ArrayList<MarkupException>();

    public VersionChecker(Version version) {
        this.version = Objects.requireNonNull(version);
    }

    @Override
    public void reset() {
        this.exceptions.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleAdded(PMMLObject object, AnnotatedElement element, Added added) {
        Version version = added.value();
        if (version == null || version.compareTo(this.version) <= 0) return;
        if (element instanceof Field) {
            Field field = (Field)element;
            Object value = ReflectionUtil.getFieldValue(field, object);
            if (VersionChecker.isAttribute(field)) {
                this.report(new UnsupportedAttributeException(object, field, value));
                return;
            } else if (VersionChecker.isEnumValue(field)) {
                this.report(new UnsupportedAttributeException(object, (Enum)value));
                return;
            } else {
                if (!VersionChecker.isElement(field)) throw new IllegalArgumentException();
                this.report(new UnsupportedElementException((PMMLObject)value));
            }
            return;
        } else {
            this.report(new UnsupportedElementException(object));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleRemoved(PMMLObject object, AnnotatedElement element, Removed removed) {
        Version version = removed.value().previous();
        if (version == null || version.compareTo(this.version) >= 0) return;
        if (element instanceof Field) {
            Field field = (Field)element;
            Object value = ReflectionUtil.getFieldValue(field, object);
            if (VersionChecker.isAttribute(field)) {
                this.report(new MisplacedAttributeException(object, field, value));
                return;
            } else {
                if (!VersionChecker.isElement(field)) throw new IllegalArgumentException();
                this.report(new MisplacedElementException((PMMLObject)value));
            }
            return;
        } else {
            this.report(new MisplacedElementException(object));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleOptional(PMMLObject object, AnnotatedElement element, Optional optional) {
        Version version = optional.value();
        if (version == null || version.compareTo(this.version) <= 0) return;
        if (!(element instanceof Field)) throw new IllegalArgumentException();
        Field field = (Field)element;
        if (VersionChecker.isAttribute(field)) {
            this.report(new MissingAttributeException(object, field));
            return;
        } else {
            if (!VersionChecker.isElement(field)) throw new IllegalArgumentException();
            this.report(new MissingElementException(object, field));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleRequired(PMMLObject object, AnnotatedElement element, Required required) {
        Version version = required.value();
        if (version == null || version.compareTo(this.version) > 0) return;
        if (!(element instanceof Field)) throw new IllegalArgumentException();
        Field field = (Field)element;
        if (VersionChecker.isAttribute(field)) {
            this.report(new MissingAttributeException(object, field));
            return;
        } else {
            if (!VersionChecker.isElement(field)) throw new IllegalArgumentException();
            this.report(new MissingElementException(object, field));
        }
    }

    protected void report(MarkupException exception) {
        this.exceptions.add(exception);
    }

    public List<MarkupException> getExceptions() {
        return this.exceptions;
    }
}

