/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dmg.pmml.DataType;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.model.ToStringHelper;

public class Schema {
    private Label label = null;
    private List<? extends Feature> features = null;

    public Schema(Label label, List<? extends Feature> features) {
        this.setLabel(label);
        this.setFeatures(features);
    }

    public Schema toRelabeledSchema(Label label) {
        List<? extends Feature> features = this.getFeatures();
        return new Schema(label, features);
    }

    public Schema toAnonymousSchema() {
        Label label = this.getLabel();
        return this.toRelabeledSchema(label != null ? label.toAnonymousLabel() : null);
    }

    public Schema toAnonymousRegressorSchema(DataType dataType) {
        switch (dataType) {
            case FLOAT: 
            case DOUBLE: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        ContinuousLabel label = new ContinuousLabel(null, dataType);
        return this.toRelabeledSchema(label);
    }

    public Schema toEmptySchema() {
        Label label = this.getLabel();
        return new Schema(label, Collections.emptyList());
    }

    public Schema toSubSchema(int[] indexes) {
        Label label = this.getLabel();
        List<? extends Feature> features = this.getFeatures();
        ArrayList<Feature> selectedFeatures = new ArrayList<Feature>(indexes.length);
        for (int index : indexes) {
            Feature feature = features.get(index);
            selectedFeatures.add(feature);
        }
        return new Schema(label, selectedFeatures);
    }

    public Schema toTransformedSchema(Function<Feature, Feature> function) {
        Label label = this.getLabel();
        List<? extends Feature> features = this.getFeatures();
        List transformedFeatures = features.stream().map(function).collect(Collectors.toList());
        return new Schema(label, transformedFeatures);
    }

    public String toString() {
        ToStringHelper helper = this.toStringHelper();
        return helper.toString();
    }

    protected ToStringHelper toStringHelper() {
        return new ToStringHelper((Object)this).add("label", (Object)this.getLabel()).add("features", this.getFeatures());
    }

    public Label getLabel() {
        return this.label;
    }

    private void setLabel(Label label) {
        this.label = label;
    }

    public Feature getFeature(int index) {
        List<? extends Feature> features = this.getFeatures();
        return features.get(index);
    }

    public List<? extends Feature> getFeatures() {
        return this.features;
    }

    private void setFeatures(List<? extends Feature> features) {
        this.features = Objects.requireNonNull(features);
    }
}

