/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.visitors;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Field;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultField;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.mining.Segment;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.regression.Regression;
import org.dmg.pmml.tree.DecisionTree;
import org.jpmml.model.visitors.AbstractVisitor;

public class FieldResolver
extends AbstractVisitor {
    private Map<PMMLObject, List<Field<?>>> scopes = new IdentityHashMap();
    private Map<PMMLObject, List<Field<?>>> customScopes = Collections.emptyMap();

    @Override
    public void applyTo(Visitable visitable) {
        this.scopes.clear();
        this.customScopes = Collections.emptyMap();
        super.applyTo(visitable);
    }

    @Override
    public PMMLObject popParent() {
        PMMLObject parent = super.popParent();
        if (parent instanceof Field) {
            Field field = (Field)parent;
            parent = this.getParent();
            List<Field<?>> customScope = this.customScopes.get(parent);
            if (customScope != null) {
                customScope.add(field);
            }
        } else if (parent instanceof TransformationDictionary) {
            PMML pmml = (PMML)this.getParent();
            this.declareGlobalFields(pmml, true);
            this.customScopes = Collections.emptyMap();
        } else if (parent instanceof LocalTransformations) {
            Model model = (Model)this.getParent();
            this.declareLocalFields(model, true);
            this.customScopes = Collections.emptyMap();
        } else {
            List<Field<?>> customScope = this.customScopes.get(parent);
            if (customScope != null) {
                this.customScopes = Collections.emptyMap();
            }
        }
        return parent;
    }

    @Override
    public VisitorAction visit(Model model) {
        this.declareLocalFields(model, true);
        return super.visit(model);
    }

    @Override
    public VisitorAction visit(DecisionTree decisionTree) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VisitorAction visit(DefineFunction defineFunction) {
        this.declareFields(defineFunction, defineFunction.hasParameterFields() ? defineFunction.getParameterFields() : Collections.emptyList());
        return super.visit(defineFunction);
    }

    @Override
    public VisitorAction visit(LocalTransformations localTransformations) {
        Model model = (Model)this.getParent();
        if (localTransformations.hasDerivedFields()) {
            this.declareLocalFields(model, false);
            this.suppressFields(localTransformations);
        }
        return super.visit(localTransformations);
    }

    @Override
    public VisitorAction visit(Output output) {
        if (output.hasOutputFields()) {
            this.declareFields(output, output.getOutputFields());
            this.suppressFields(output);
        }
        return super.visit(output);
    }

    @Override
    public VisitorAction visit(PMML pmml) {
        this.declareGlobalFields(pmml, true);
        return super.visit(pmml);
    }

    @Override
    public VisitorAction visit(Regression regression) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VisitorAction visit(ResultField resultField) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VisitorAction visit(TransformationDictionary transformationDictionary) {
        PMML pmml = (PMML)this.getParent();
        if (transformationDictionary.hasDerivedFields()) {
            this.declareGlobalFields(pmml, false);
            this.suppressFields(transformationDictionary);
        }
        return super.visit(transformationDictionary);
    }

    public Collection<Field<?>> getFields() {
        Deque<PMMLObject> parents = this.getParents();
        return this.getFields(parents);
    }

    public Collection<Field<?>> getFields(PMMLObject ... virtualParents) {
        ArrayDeque<PMMLObject> parents = new ArrayDeque<PMMLObject>(this.getParents());
        for (PMMLObject virtualParent : virtualParents) {
            parents.push(virtualParent);
        }
        return this.getFields(parents);
    }

    private Collection<Field<?>> getFields(Deque<PMMLObject> parents) {
        ArrayList result = new ArrayList();
        PMMLObject prevParent = null;
        for (PMMLObject parent : parents) {
            List<Field<?>> scope = this.getScope(parent);
            if (scope != null && scope.size() > 0) {
                result.addAll(scope);
            }
            if (parent instanceof DefineFunction) break;
            if (parent instanceof Segmentation && (prevParent == null || prevParent instanceof Segment)) {
                List<Output> outputs = FieldResolver.getEarlierOutputs((Segmentation)parent, (Segment)prevParent);
                for (Output output : outputs) {
                    List<Field<?>> scope2 = this.getScope(output);
                    if (scope2 == null || scope2.size() <= 0) continue;
                    result.addAll(scope2);
                }
            }
            prevParent = parent;
        }
        return result;
    }

    private List<Field<?>> getScope(PMMLObject object) {
        if (this.customScopes.size() > 0) {
            return this.customScopes.getOrDefault(object, this.scopes.get(object));
        }
        return this.scopes.get(object);
    }

    private void declareGlobalFields(PMML pmml, boolean transformations) {
        DataDictionary dataDictionary;
        List<Field<?>> scope = this.scopes.get(pmml);
        if (scope != null) {
            scope.clear();
        }
        if ((dataDictionary = pmml.getDataDictionary()) != null && dataDictionary.hasDataFields()) {
            this.declareFields(pmml, dataDictionary.getDataFields());
        }
        TransformationDictionary transformationDictionary = pmml.getTransformationDictionary();
        if (transformations && transformationDictionary != null && transformationDictionary.hasDerivedFields()) {
            this.declareFields(pmml, transformationDictionary.getDerivedFields());
        }
    }

    private void declareLocalFields(Model model, boolean transformations) {
        List<Field<?>> scope = this.scopes.get(model);
        if (scope != null) {
            scope.clear();
        }
        LocalTransformations localTransformations = model.getLocalTransformations();
        if (transformations && localTransformations != null && localTransformations.hasDerivedFields()) {
            this.declareFields(model, localTransformations.getDerivedFields());
        }
    }

    private void declareFields(PMMLObject object, Collection<? extends Field<?>> fields) {
        List<Field<?>> scope = this.scopes.get(object);
        if (scope == null) {
            scope = new ArrayList(fields.size());
            this.scopes.put(object, scope);
        }
        scope.addAll(fields);
    }

    private void suppressFields(PMMLObject object) {
        this.customScopes = Collections.singletonMap(object, new ArrayList());
    }

    private static List<Output> getEarlierOutputs(Segmentation segmentation, Segment targetSegment) {
        ArrayList<Output> result = new ArrayList<Output>();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case MODEL_CHAIN: {
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        List<Segment> segments = segmentation.getSegments();
        for (Segment segment : segments) {
            Model model = segment.getModel();
            if (targetSegment != null && targetSegment.equals(segment)) break;
            Output output = model.getOutput();
            if (output == null) continue;
            result.add(output);
        }
        return result;
    }
}

