% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize_RFU.R
\name{normalize_RFU}
\alias{normalize_RFU}
\title{Normalize Fluorescence}
\usage{
normalize_RFU(df, bg_cycle = 4)
}
\arguments{
\item{df}{A dataframe made from get_real.}

\item{bg_cycle}{The cycle used for background fluorescence}
}
\value{
A dataframe containing real-time normalized fluorescence values.
}
\description{
Normalizes the real-time RT-QuIC data against the background fluorescence of
a defined cycle. All cycles are divided by the fluorescent value of the
defined cycle.
}
\examples{
# This test takes >5 sec
\donttest{
file <- system.file(
  "extdata/input_files",
  file = "test.xlsx",
  package = "quicR"
)
df_ <- get_real(file)[[1]]

# Export the tables in the first sheet of the file.
dic <- quicR::organize_tables(file)

# Apply the column names.
colnames(df_) <- cbind("Time", convert_tables(dic)$`Sample IDs` |> t())

# Normalize the raw data against the background reading.
normalize_RFU(df_)
}


}
