% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_TtT.R
\name{calculate_TtT}
\alias{calculate_TtT}
\title{Calculate Time to Threshold}
\usage{
calculate_TtT(data, threshold, start_col = 3, run_time = 48)
}
\arguments{
\item{data}{A dataframe containing real-time RT-QuIC data.}

\item{threshold}{A numeric value defining the threshold.}

\item{start_col}{The column containing the starting position of the real-time data.}

\item{run_time}{The time in hours that the assay ran.}
}
\value{
A vector containing the times to threshold
}
\description{
Calculates the time required to reach a defined threshold.
}
\examples{
# This test takes >5 sec
\donttest{
file <- system.file(
"extdata/input_files",
file = "test.xlsx",
package = "quicR"
)
df_ <- get_real(file)[[1]] |>
  normalize_RFU()
calculate_TtT(df_, threshold = 2)
}


}
