% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psymet_functions.R
\name{ucfa}
\alias{ucfa}
\title{Unidimensional Confirmatory Factor Analysis}
\usage{
ucfa(
  data,
  vrb.nm,
  std.ov = FALSE,
  std.lv = TRUE,
  ordered = FALSE,
  meanstructure = TRUE,
  estimator = "ML",
  se = "standard",
  test = "standard",
  missing = "fiml",
  ...
)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} providing the
variables/items}

\item{std.ov}{logical vector of length 1 specifying if the variables/items
should be standardized}

\item{std.lv}{logical vector of length 1 specifying if the latent factor
should be standardized resulting in all factor loadings being estimated. If
FALSE, then the first variable/item in \code{data[vrb.nm]} is fixed to a
factor loading of 1.}

\item{ordered}{logical vector of length 1 specifying if the variables/items
should be treated as ordered categorical items where polychoric
correlations are used.}

\item{meanstructure}{logical vector of length 1 specifying if the mean
structure of the factor model should be estimated. This would be the
variable/item intercepts (and latent factor mean if \code{std.lv} = FALSE).
Note, this must be true to use Full Information Maximum Likelihood (FIML)
to handle missing data via \code{missing} = "fiml".}

\item{estimator}{character vector of length 1 specifying the estimator to use
for parameter estimation. Popular options are 1) "ML" = maximum likelihood
estimation based on the multivariate normal distribution, 2) "DWLS" =
diagonally weighted least squares which uses the diagnonal of the weight
matrix, 3) "WLS" for weighted least squares whiches uses the full weight
matrix (often results in computational problems), 4) "ULS" for unweighted
least squares that doesn't use a weight matrix. "DWLS", "WLS", and "ULS"
can each be used with ordered categorical items when \code{ordered} = TRUE.}

\item{se}{character vector of length 1 specifying how standard errors should
be calculated. Popular options are 1) "standard" for conventional standard
errors from inverting the information matrix, 2) "robust.sem" for robust
standard errors, 3) "robust.huber.white" for sandwich standard errors.}

\item{test}{character vector of length 1 specifying how the omnibus test
statistic should be calculated. Popular options are 1) "standard" for the
conventional chi-square statistic, 2) "Satorra-Bentler" for the
Satorra-Bentler test statistic, 3) "Yaun.Bentler.Mplus" for the version of
the Yuan-Bentler test statistic that Mplus uses, 4) "mean.var.adjusted" for
a mean and variance adjusted test statistic, 5) "scaled.shifted" for the
version of the mean and variance adjusted test statistic Mplus uses.}

\item{missing}{character vector of length 1 specifying how to handle missing
data. Popular options are 1) "fiml" = Full Information Maximum Likelihood
(FIML), 2) "pairwise" = pairwise deletion, 3) "listwise" = listwise
deletion.}

\item{...}{any other named arguments available in the
\code{\link[lavaan]{cfa}} function. See \code{\link[lavaan]{lavOptions}}
for the list of arguments.}
}
\value{
object of class "lavaan" \code{\linkS4class{lavaan}}
  providing the return object from a call to \code{\link[lavaan]{cfa}}.
}
\description{
\code{ucfa} conducts a unidimensional confirmatory factor analysis on a set
of variables/items. Unidimensional meaning a one-factor model where all
variables/items load on that factor. The function is a wrapper for
\code{\link[lavaan]{cfa}} and returns an object of class "lavaan":
\code{\linkS4class{lavaan}}. This then allows the user to extract
statistical information from the object (e.g.,
\code{\link[lavaan]{lavInspect}}). For details on all the arguments see
\code{\link[lavaan]{lavOptions}}.
}
\examples{

dat <- psych::bfi[1:250, 16:20] # nueroticism items
ucfa(data = dat, vrb.nm = names(dat))
ucfa(data = dat, vrb.nm = names(dat), std.ov = TRUE)
ucfa(data = dat, vrb.nm = names(dat), meanstructure = FALSE, missing = "pairwise")
ucfa(data = dat, vrb.nm = names(dat), estimator = "ML", # MLR
   se = "robust.huber.white", test = "yuan.bentler.mplus", missing = "fiml")
ucfa(data = dat, vrb.nm = names(dat), estimator = "ML", # MLM
   se = "robust.sem", test = "satorra.bentler", missing = "listwise")
ucfa(data = dat, vrb.nm = names(dat), ordered = TRUE, estimator = "DWLS", # WLSMV
   se = "robust", test = "scaled.shifted", missing = "listwise")

}
\seealso{
\code{\link{summary_ucfa}}
   \code{\link[lavaan]{cfa}}
   \code{\link[lavaan]{lavaan}}
}
