% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{reverse}
\alias{reverse}
\title{Reverse Code a Numeric Vector}
\usage{
reverse(x, mini, maxi)
}
\arguments{
\item{x}{numeric vector.}

\item{mini}{numeric vector of length 1 specifying the minimum numeric value.}

\item{maxi}{numeric vector of length 1 specifying the maximum numeric value.}
}
\value{
numeric vector that correlates exactly -1 with \code{x}.
}
\description{
\code{reverse} reverse codes a numeric vector based on minimum and maximum
values. For example, say numerical values of response options can range from
1 to 4. The function will change 1 to 4, 2 to 3, 3 to 2, and 4 to 1. If there
are an odd number of response options, the middle in the sequence will be
unchanged.
}
\examples{
x <- psych::bfi[[1]]
head(x, n = 15)
y <- reverse(x = psych::bfi[[1]], min = 1, max = 6)
head(y, n = 15)
cor(x, y, use = "complete.obs")
}
\seealso{
\code{\link{reverses}}
   \code{\link[psych]{reverse.code}}
   \code{\link[car]{recode}}
}
