% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preview.R
\name{quarto_preview}
\alias{quarto_preview}
\alias{quarto_preview_stop}
\title{Quarto Preview}
\usage{
quarto_preview(
  file,
  render = TRUE,
  port = "auto",
  host = "127.0.0.1",
  browse = TRUE
)

quarto_preview_stop()
}
\arguments{
\item{file}{Quarto document to preview.}

\item{render}{Automatically re-render the document when it changes.}

\item{port}{Port to listen on (defaults to 4848)}

\item{host}{Hostname to bind to (defaults to 127.0.0.1)}

\item{browse}{Open a browser to preview the content. Defaults to using the
RStudio Viewer when running within RStudio.Pass a function (e.g.
\code{utils::browseURL} to override this behavior).}
}
\description{
Render and preview a Quarto document. Automatically re-renders the document
when the source file changes. Automatically reloads the browser when
document resources (e.g. CSS) change.
}
\details{
Pass \code{render = FALSE} to prevent re-rendering when the source file
changes (note that even when this option is provided the document will be
rendered once before previewing).
}
\examples{
\dontrun{
# Preview a document
quarto_preview("document.qmd")

# Stop any running preview
quarto_preview_stop()
}

}
