% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-ClippedCov.R
\name{ClippedCov-constructor}
\alias{ClippedCov-constructor}
\alias{clippedCov}
\title{Create an instance of the \code{\link{ClippedCov}} class.}
\usage{
clippedCov(
  Y,
  maxLag = length(Y) - 1,
  levels.1 = c(0.5),
  levels.2 = levels.1,
  isRankBased = TRUE,
  B = 0,
  l = 0,
  type.boot = c("none", "mbb")
)
}
\arguments{
\item{Y}{Time series to calculate the copula covariance from}

\item{maxLag}{maximum lag between observations that should be used}

\item{levels.1}{a vector of numerics that determines the level of clipping}

\item{levels.2}{a vector of numerics that determines the level of clipping}

\item{isRankBased}{If true the time series is first transformed to pseudo data;
currently only rank-based estimation is possible.}

\item{B}{number of bootstrap replications}

\item{l}{(expected) length of blocks}

\item{type.boot}{A flag to choose a method for the block bootstrap; currently
two options are implemented: \code{"none"} and \code{"mbb"}
which means to do a moving blocks  bootstrap with \code{B}
and \code{l} as specified.}
}
\value{
Returns an instance of \code{ClippedCov}.
}
\description{
Create an instance of the \code{\link{ClippedCov}} class.
}
\examples{
ccf <- clippedCov(rnorm(200), maxLag = 25, levels.1 = c(0.1,0.5,0.9))
dim(getValues(ccf))
#print values for levels (.5,.5)
plot(ccf, maxLag = 20)
}
\seealso{
\code{\link{LagOperator}}
}
\keyword{Constructors}
