% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R, R/nsyllable.R,
%   R/textstat_readability.R
\docType{data}
\name{data-internal}
\alias{data-internal}
\alias{data_int_syllables}
\alias{data_char_wordlists}
\title{Internal data sets}
\format{An object of class \code{integer} of length 133245.}
\usage{
data_int_syllables

data_char_wordlists
}
\description{
Data sets used for mainly internal purposes by the \pkg{quanteda} package.
}
\details{
\code{data_int_syllables} provides an English-language syllables dictionary;
it is an integer vector whose element names correspond to English words.

\code{data_char_wordlists} provides word lists used in some readability indexes; 
it is a named list of character vectors where each list element 
corresponds to a different readability index.  

These are:
\describe{
\item{\code{DaleChall}}{The long Dale-Chall list of 3,000 familiar (English) words needed to compute the Dale-Chall Readability Formula.}
\item{\code{Spache}}{The revised Spache word list (see Klare 1975, 73) needed to compute the Spache Revised Formula of readability (Spache 1974.}
}
}
\references{
Chall, J. S., & Dale, E.  1995. \emph{Readability Revisited: The New Dale-Chall Readability Formula}. Brookline Books.

Klare, G. R. 1975. "Assessing readability." \emph{Reading Research Quarterly} 10(1): 62-102.

Spache, G. 1953. "A new readability formula for primary-grade reading materials." \emph{The Elementary School Journal} 53: 410-413.
}
\keyword{data}
\keyword{datasets}
\keyword{internal}
